/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.tomcat;

import com.suncode.autoupdate.tomcat.Consumer;
import com.suncode.autoupdate.tomcat.Hook;
import com.suncode.autoupdate.tomcat.RunJar;
import java.io.File;
import java.lang.reflect.Method;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

public class Bootstrap
implements LifecycleListener {
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            if (event.getType().equals("before_start")) {
                Object source = event.getSource();
                System.out.println(String.format("[Patcher-Bootstrap]: Caught event of type=%s source=%s", event.getType(), source.getClass().getName()));
                if (source instanceof Context) {
                    this.bootstrap((Context)source);
                }
            }
        }
        catch (Throwable e) {
            System.out.println("[Patcher-Bootstrap]: Unexpected error when bootstrapping: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    private void bootstrap(Context context) {
        final File root = Hook.get().getRoot(context);
        final File patcherBin = new File(root, ".patcher/patcher.jar");
        if (patcherBin.exists()) {
            System.out.println("[Patcher-Bootstrap]: found @" + root.getAbsolutePath());
            RunJar run = new RunJar(patcherBin);
            run.invoke(new Consumer<Class<?>>(){

                @Override
                public void accept(Class<?> mainClass) {
                    String[] args = new String[]{root.getAbsolutePath(), patcherBin.getAbsolutePath()};
                    Method main = mainClass.getMethod("main", String[].class);
                    main.invoke(null, new Object[]{args});
                }
            });
        } else {
            System.out.println("[Patcher-Bootstrap]: No patcher binary found on " + patcherBin.getAbsolutePath());
        }
    }

    static {
        System.out.println("[Patcher-Bootstrap]: initialized");
    }
}

