package com.suncode.autoupdate.tomcat;

import java.io.File;
import java.io.InputStream;

import javax.servlet.ServletContext;

import org.apache.catalina.Context;

public interface Impl
{   
    /**
     * @return if this impl can be used
     */
    boolean active();
    
    /**
     * @return context root directory
     */
    File getRoot(Context context);
    
    /**
     * @return context under give ServletContext
     */
    Context getContext(ServletContext servletContext); 
    
    /**
     * Registers hook
     */
    void registerHook(ServletContext context, InputStream bootstrapJar);
    
    /**
     * Returns true if hook is registered
     */
    boolean isHookRegisterd(ServletContext context);
}
