import React from 'react';
import Project from './Project.jsx';
import ProjectsTable from './ProjectsTable.jsx';
import Select2 from './../../components/Select2.jsx';
import Select from 'react-select';

export default class Projects extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            projectTypes: [
              {value: 'PLUSWORKFLOW', label: 'PlusWorkflow'},
              {value: 'PLUGIN', label: 'Plugin'}],
            projectType: 'PLUSWORKFLOW'
        };
    }
    render() {
        return <div>
          <div className="row">
            <div className="col-lg-8">
                <div className="well">
                  <ProjectsTable></ProjectsTable>
                </div>
            </div>
            <div className="col-lg-4">{this.renderAddForm()}</div>
          </div>
        </div>
    }

    renderAddForm() {
      return <div className="well">
          <form className="smart-form" onSubmit={this.createProject}>
              <fieldset>
                  <section>
                      <label className="label">Nazwa</label>
                      <label className="input">
                          <input name="name" type="text"/>
                      </label>
                  </section>
                  <section>
                    <Select
                      name="type"
                      value={this.state.projectType}
                      options={this.state.projectTypes}
                      onChange={newValue => {
                        this.setState({projectType: newValue});
                      } }/>
                  </section>
              </fieldset>
              <footer>
                  <button type="submit" className="btn btn-primary">
                      Dodaj projekt
                  </button>
              </footer>
          </form>
      </div>
    }

    createProject(e) {
        e.preventDefault();

        var form = new FormData(e.currentTarget);
        var projectName = form.get('name');
        var projectType = form.get('type');
        $.ajax({
            url: "projects",
            method: 'POST',
            data: {
              name: projectName,
              type: projectType
            },
            success: function(data) {
                $('#projects-table').dataTable().api().ajax.reload();
            }.bind(this)
        });
    }
}
