import React from "react";
import Select2 from "./../../components/Select2.jsx";
import Select from "react-select";
import AsyncSelect from "react-select/async";

export default class ConfigurationWizard extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      generating: false,
      environment: props.client.environments[0]
    };

    this.onSubmit = this.onSubmit.bind(this);
  }
  onSubmit() {
    var data = {
      project: this.state.project,
      channel: this.state.channel,
      env: this.state.environment,
      path: this.state.path
    };
    var paramString = $.param(data);
    var url = "/clients/" + this.props.client.id + "/config?" + paramString;

    saveAs(url, "updater.properties");

    return false;
  }
  render() {
    return (
      <form
        onSubmit={this.onSubmit}
        className="well"
        style={{
          backgroundColor: "white"
        }}
      >
        <fieldset>
          <p className="text-muted">
            Uzupełnij wszystkie pola i kliknij <code>Generuj</code>. Zostanie
            wygenerowany plik konfiguracji aktualizatora.
          </p>
          <label>Projekt</label>
          <div className="form-group">
            <AsyncSelect
              name="project"
              cacheOptions
              defaultOptions
              loadOptions={this.fetchProjects}
              onChange={option => {
                this.setState({
                  project: option.value,
                  channels: option.channels
                });
              }}
            />
          </div>
          <label>Kanał aktualizacji</label>
          <div className="form-group">
            <Select
              name="channel"
              options={this.state.channels}
              onChange={option => {
                this.setState({ channel: option.value });
              }}
            />
          </div>
          <label>Środowisko</label>
          <div className="form-group">
            <Select2
              values={this.props.client.environments.map(env => {
                return { id: env, text: env };
              })}
              searchBox={false}
              multiple={false}
              onChange={newValue => {
                this.setState({ environment: newValue });
              }}
            />
          </div>
          <label>Lokalizacja na serwerze</label>
          <p className="text-muted">
            Absolutna ścieżka do aplikacji na serwerze np.{" "}
            <code>/home/suncode/tomcat/webapps/PlusWorkflow</code>
          </p>
          <div className="form-group">
            <input
              type="text"
              className="form-control"
              onChange={e => {
                this.setState({ path: e.target.value });
              }}
            />
          </div>
        </fieldset>
        <div className="form-actions">
          <div className="row">
            <div className="col-lg-12">
              <button
                disabled={this.state.generating}
                className="btn btn-primary"
                onClick={this.generate}
              >
                Generuj
              </button>
            </div>
          </div>
        </div>
      </form>
    );
  }

  fetchProjects(input, callback) {
    $.get("projects").done(projects => {
      callback(
        projects.map(project => {
          return {
            value: project.name,
            label: project.name,
            channels: project.channels.map(channel => {
              return { value: channel, label: channel };
            })
          };
        })
      );
    });
  }
}

function saveAs(uri, filename) {
  var link = document.createElement("a");
  if (typeof link.download === "string") {
    document.body.appendChild(link);
    link.download = filename;
    link.href = uri;
    link.click();
    document.body.removeChild(link);
  } else {
    location.replace(uri);
  }
}
