import React from 'react';

export default class Table extends React.Component {

    componentDidMount() {
        setTimeout(function() {
            $('#' + this.props.id).DataTable(this.tableConfig());
        }.bind(this), 1);
    }

    render() {
        return (
            <div className="dataTables_wrapper">
                <table id={this.props.id} className="table table-bordered table-hover"/>
            </div>
        )
    }

    tableConfig() {
        return {
            "paging": false,
            "info": false,
            "searching": false,
            "language": {
                "emptyTable": "Brak danych"
            },
            ajax: {
                url: this.props.path,
                dataSrc: ''
            },
            columns: this.props.columns
        };
    }
}
