/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.store;

import com.google.common.collect.ImmutableMap;
import com.suncode.autoupdate.server.client.api.Product;
import com.suncode.autoupdate.server.store.ProductsStorage;
import com.suncode.autoupdate.server.store.Store;
import com.suncode.autoupdate.server.store.wooapi.Image;
import com.suncode.autoupdate.server.store.wooapi.Product;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class Store {
    private final ProductsStorage productsStorage;
    private static final Locale PL = new Locale("pl");
    private static final Locale EN = new Locale("en");
    private static final Map<Locale, ProductExtractor> LOOKUP = ImmutableMap.of((Object)PL, (Object)ProductExtractor.pl(), (Object)EN, (Object)ProductExtractor.en());

    public List<com.suncode.autoupdate.server.client.api.Product> list(Locale locale) {
        Locale wantedLocale = Locale.lookup(Locale.LanguageRange.parse(locale.toLanguageTag()), LOOKUP.keySet());
        ProductExtractor extractor = wantedLocale != null ? (ProductExtractor)LOOKUP.get(wantedLocale) : ProductExtractor.en();
        return this.productsStorage.getMappedProducts().stream().map(item -> {
            Product product = (Product)extractor.apply(item);
            return new com.suncode.autoupdate.server.client.api.Product(item.getProjectId(), product.getSlug().asString(), product.getName(), product.getShortDescription(), product.getPrice(), product.getPriceHtml(), product.getCategories().stream().map(tag -> new Product.Tag(tag.getSlug(), tag.getName())).collect(Collectors.toList()), product.getTags().stream().map(tag -> new Product.Tag(tag.getSlug(), tag.getName())).collect(Collectors.toList()), product.getPermalink(), ((Image)product.getImages().get(0)).getSrc());
        }).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"productsStorage"})
    public Store(ProductsStorage productsStorage) {
        this.productsStorage = productsStorage;
    }
}

