/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.project.dto;

import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.client.Client;
import com.suncode.autoupdate.server.client.dto.ClientDto;
import com.suncode.autoupdate.server.project.Project;
import java.util.ArrayList;
import java.util.List;

public class ProjectDto {
    private String name;
    private String type;
    private List<String> channels = new ArrayList();
    private List<ClientDto> permittedClients = new ArrayList();

    public ProjectDto() {
    }

    public ProjectDto(Project project) {
        this.name = project.getName();
        this.type = project.getPatchFormat().name();
        for (Channel channel : project.getChannels()) {
            this.channels.add(channel.getId().getName());
        }
        for (Client client : project.getPermittedClients()) {
            this.permittedClients.add(new ClientDto(client));
        }
    }

    public static List<ProjectDto> from(Iterable<Project> projects) {
        ArrayList<ProjectDto> result = new ArrayList<ProjectDto>();
        for (Project project : projects) {
            result.add(new ProjectDto(project));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public List<ClientDto> getPermittedClients() {
        return this.permittedClients;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setChannels(List<String> channels) {
        this.channels = channels;
    }

    public void setPermittedClients(List<ClientDto> permittedClients) {
        this.permittedClients = permittedClients;
    }
}

