/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.channel;

import com.suncode.autoupdate.server.channel.TempResourcesController;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resources/{resourceId}"})
@Secured(value={"ROLE_ADMIN"})
public class TempResourcesController {
    private static final Logger log = LoggerFactory.getLogger(TempResourcesController.class);
    private final Map<UUID, TempResource> resources = new ConcurrentHashMap();

    public URI serve(String filename, File file) {
        UUID id = UUID.randomUUID();
        this.resources.put(id, new TempResource(file, filename));
        return ControllerLinkBuilder.linkTo(TempResourcesController.class, (Object[])new Object[]{id}).toUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping
    public void resource(@PathVariable UUID resourceId, HttpServletResponse response) {
        TempResource resource = (TempResource)this.resources.get(resourceId);
        try {
            response.setHeader("Content-Type", "application/octet-stream");
            response.setContentLengthLong(resource.getFile().length());
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", resource.getFilename()));
            try (FileInputStream in = new FileInputStream(resource.getFile());
                 ServletOutputStream out = response.getOutputStream();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
        finally {
            resource.getFile().delete();
        }
    }
}

