/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.channel;

import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patch.plusworkflow.archive.merge.ArchiveMerger;
import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.channel.Channels;
import com.suncode.autoupdate.server.channel.TempResourcesController;
import com.suncode.autoupdate.server.channel.UpdateChannel;
import com.suncode.autoupdate.server.channel.dto.ChannelGraphDto;
import com.suncode.autoupdate.server.channel.dto.UpdateChannelDto;
import com.suncode.autoupdate.server.channel.graph.ChannelGraph;
import com.suncode.autoupdate.server.patch.Version;
import com.suncode.autoupdate.server.patch.dto.PatchDto;
import com.suncode.autoupdate.server.patch.storage.PatchStorage;
import com.suncode.autoupdate.server.project.Project;
import com.suncode.autoupdate.server.project.ProjectRepository;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projects/{projectId:.+}/channels"})
@Secured(value={"ROLE_ADMIN"})
public class ChannelController {
    private static final Logger log = LoggerFactory.getLogger(ChannelController.class);
    @Autowired
    private Channels channels;
    @Autowired
    private ProjectRepository projectRepo;
    @Autowired
    private PatchStorage patchStorage;
    @Autowired
    private TempResourcesController tempResourcesController;

    @RequestMapping(value={"/{channelId}"})
    public UpdateChannelDto getChannel(@PathVariable String projectId, @PathVariable String channelId) {
        UpdateChannel channel = this.channels.get(Channel.ChannelId.of((String)channelId, (String)projectId));
        return new UpdateChannelDto(channel);
    }

    @RequestMapping(value={""})
    public List<UpdateChannelDto> getChannels(@PathVariable String projectId) {
        ArrayList<UpdateChannelDto> result = new ArrayList<UpdateChannelDto>();
        Project project = (Project)this.projectRepo.findOne((Serializable)((Object)projectId));
        for (Channel channel : project.getChannels()) {
            result.add(new UpdateChannelDto(this.channels.get(channel.getId())));
        }
        return result;
    }

    @RequestMapping(value={"/{channelId}"}, method={RequestMethod.POST})
    public UpdateChannelDto create(@PathVariable String projectId, @PathVariable String channelId) {
        UpdateChannel channel = this.channels.create(Channel.ChannelId.of((String)channelId, (String)projectId));
        return new UpdateChannelDto(channel);
    }

    @RequestMapping(value={"/{channelId}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable String projectId, @PathVariable String channelId) {
        this.channels.remove(Channel.ChannelId.of((String)channelId, (String)projectId));
    }

    @RequestMapping(value={"/{channelId}/graph"}, method={RequestMethod.GET})
    public ChannelGraphDto graph(@PathVariable String projectId, @PathVariable String channelId) {
        ChannelGraph graph = this.channels.get(Channel.ChannelId.of((String)channelId, (String)projectId)).graph();
        return new ChannelGraphDto(graph);
    }

    @RequestMapping(value={"/{channelId}/patches"}, method={RequestMethod.GET})
    public List<PatchDto> list(@PathVariable String projectId, @PathVariable String channelId) {
        return this.channels.get(Channel.ChannelId.of((String)channelId, (String)projectId)).getPatches().stream().map(PatchDto::new).collect(Collectors.toList());
    }

    @GetMapping(value={"/{channelId}/merge"})
    public ResponseEntity merge(@PathVariable String projectId, @PathVariable String channelId, @RequestParam String from, @RequestParam String to) {
        UpdateChannel channel = this.channels.get(Channel.ChannelId.of((String)channelId, (String)projectId));
        List patches = channel.graph().shortestPath(new Version(from), new Version(to));
        if (patches.isEmpty()) {
            return ResponseEntity.badRequest().body((Object)("No connection exists between #" + from + " and #" + to));
        }
        log.info("Generating merged patch using {}", (Object)patches);
        ArchiveMerger merger = patches.stream().map(patch -> this.patchStorage.read(patch)).map(resource -> this.archive(resource)).collect(Collectors.collectingAndThen(Collectors.toList(), ArchiveMerger::new));
        File output = File.createTempFile("patch-merged-", ".zip");
        output.deleteOnExit();
        log.info("Merging started");
        merger.merge(output);
        URI uri = this.tempResourcesController.serve(String.format("patch-#%s-#%s.patch", from, to), output);
        log.info("Merged patch generated under {}", (Object)uri);
        return ResponseEntity.ok((Object)uri);
    }

    private Archive archive(Resource resource) {
        return new Archive(resource.getFile());
    }
}

