import React from 'react';
import AddChannel from './AddChannel.jsx';
import Channel from './Channel.jsx';
import PatchesTable from './PatchesTable.jsx';

export default class Channels extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
        this.channelAdded = this.channelAdded.bind(this);
        this.onDelete = this.onDelete.bind(this);
    }
    componentDidMount() {
        $.ajax({
            url: "projects/" + this.props.project.name + '/channels',
            method: 'GET',
            success: function(data) {
                this.setState({channels: data})
            }.bind(this)
        });
    }

    channelAdded(channel) {
        this.state.channels.push(channel);
        this.forceUpdate();
    }

    render() {
        if (!this.state.channels) {
            return <h1 className="ajax-loading-animation">
                <i className="fa fa-cog fa-spin"></i>
            </h1>;
        }
        return (
            <div>
                <div className="row">
                    <div className="col-lg-4">
                        <h1 className="page-title txt-color-blueDark">
                            Kanały aktualizacji
                        </h1>
                    </div>
                </div>
                <div className="row">
                    <div className="col-lg-4">
                        <AddChannel project={this.props.project} callback={this.channelAdded}/> {this.state.channels.map(this.renderChannel.bind(this))}
                    </div>
                    <div id="channel-container" className="col-lg-8"></div>
                </div>
            </div>
        );
    }

    renderChannel(channel) {
        return <Channel onDelete={this.onDelete} key={channel.name} project={this.props.project} channel={channel}/>
    }

    onDelete(deleted) {
        this.setState({
          channels: this.state.channels.filter(channel => channel.name !== deleted)
        });
    }
}
