import React from 'react';

export default class EventDetails extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
    }

    componentDidMount() {
        this.showModal();
    }
    componentDidUpdate() {
        this.showModal();
    }

    showModal() {
        if (!this.props.event) {
            return;
        }

        var event = $('#events').dataTable().api().rows().data().toArray().find((row) => {
            return row.id == this.props.event;
        });
        if (event) {
            if (event.data) {
                var node = JsonHuman.format(JSON.parse(event.data), {showArrayIndex: false});
                $(node).add($(node).find('table')).addClass('table table-hover table-bordered');
                $('.data-container').append(node);
            }
            $(this.refs.modal).modal().on('hidden.bs.modal', () => {
              this.props.onClose();
            });
        }
    }

    render() {
        if (!this.props.event) {
            return null;
        }
        return (
            <div ref="modal" className="modal fade" style={{
                display: 'none'
            }}>
                <div className="modal-dialog" style={{
                    width: '800px'
                }}>
                    <div className="modal-content">
                        <div className="modal-header">
                            <h4 className="modal-title">Szczegóły zdarzenia</h4>
                        </div>
                        <div className="modal-body">
                            {this.renderPatchInfo()}
                            <h3>Dodatkowe dane</h3>
                            <div className="data-container" style={{
                                overflow: 'scroll',
                                maxHeight: '300px'
                            }}></div>
                        </div>
                        <div className="modal-footer">
                            <button type="button" className="btn btn-default" data-dismiss="modal">
                                Zamknij
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        );
    }

    renderPatchInfo() {
        var event = $('#events').dataTable().api().rows().data().toArray().find((row) => {
            return row.id == this.props.event;
        });
        if (!event || !event.patchId) {
            return null;
        }
        return (
            <div>
                <p className="text-muted">Aktualizacja z wersji:&nbsp;
                    <span className="txt-color-darken">{event.fromVersion}</span>
                </p>
                <p className="text-muted">Do wersji:&nbsp;
                    <span className="txt-color-darken">{event.toVersion}</span>
                </p>
                <p className="text-muted">Patch:&nbsp;
                    <span className="txt-color-darken">{event.patchId}</span>
                </p>
            </div>
        );
    }
}
