package com.suncode.autoupdate.server.util;

import lombok.experimental.UtilityClass;

import java.util.function.Function;
import java.util.function.Predicate;

@UtilityClass
public class Predicates {

    public static <T, V> Predicate<V> compose(Predicate<T> predicate, Function<V, T> fn) {
        return v -> predicate.test(fn.apply(v));
    }

}
