package com.suncode.autoupdate.server.store.wooapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.icoderman.woocommerce.oauth.OAuthConfig;
import com.icoderman.woocommerce.oauth.OAuthSignature;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.icoderman.woocommerce.HttpMethod.GET;


@Component
@RequiredArgsConstructor
public class WooApi {
    private final ApiConfig apiConfig;
    private final ObjectMapper objectMapper;
    private final OkHttpClient httpClient = new OkHttpClient.Builder()
            .readTimeout(5, TimeUnit.MINUTES)
            .build();


    public V3 v3() {
        return new V3();
    }

    @RequiredArgsConstructor
    public class V3 {

        @SneakyThrows
        public List<Product> products(int page) {

            // Setup client
            OAuthConfig config = new OAuthConfig(
                    apiConfig.getApiURL(),
                    apiConfig.getCredentials().getKey(),
                    apiConfig.getCredentials().getSecret()
            );


            String url = String.format("%s/wp-json/wc/%s/%s", apiConfig.getApiURL(), "v3", "products");
            String signature = OAuthSignature.getAsQueryString(config, url, GET, ImmutableMap.of(
                    "per_page", "100",
                    "page", String.valueOf(page)
            ));
            String securedUrl = String.format("%s?%s", url, signature);

            Call call = httpClient.newCall(
                    new Request.Builder()
                            .url(securedUrl)
                            .addHeader("Accept", "application/json")
                            .addHeader("Content-Type", "application/json")
                            .get()
                            .build()
            );

            Response response = call.execute();
            String string = response.body().string();

            Pattern pattern = Pattern.compile("<script>.*<\\/script>", Pattern.DOTALL);
            Matcher matcher = pattern.matcher(string);

            String clean = matcher.replaceAll("");
            return objectMapper.readValue(clean, new TypeReference<List<Product>>() {
            });
        }

    }
}
