package com.suncode.autoupdate.server.project.dto;

import java.util.ArrayList;
import java.util.List;

import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.client.Client;
import com.suncode.autoupdate.server.client.dto.ClientDto;
import com.suncode.autoupdate.server.project.Project;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class ProjectDto
{
    private String name;
    
    private String type;

    private List<String> channels = new ArrayList<String>();

    private List<ClientDto> permittedClients = new ArrayList<ClientDto>();

    public ProjectDto()
    {
    }

    public ProjectDto( Project project )
    {
        this.name = project.getName();
        this.type = project.getPatchFormat().name();
        for ( Channel channel : project.getChannels() )
        {
            this.channels.add( channel.getId().getName() );
        }
        for ( Client client : project.getPermittedClients() )
        {
            this.permittedClients.add( new ClientDto( client ) );
        }
    }

    public static List<ProjectDto> from( Iterable<Project> projects )
    {
        List<ProjectDto> result = new ArrayList<>();
        for ( Project project : projects )
        {
            result.add( new ProjectDto( project ) );
        }
        return result;
    }
}
