package com.suncode.autoupdate.server.project;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;

import org.springframework.util.Assert;

import com.suncode.autoupdate.server.patch.PatchFormat;
import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.client.Client;

@Entity
public class Project
{
    private static final String NAME_REGEX = "[a-zA-Z][a-zA-Z0-9-_\\.]{0,50}";

    @Id
    private String name;

    @OneToMany( cascade = CascadeType.ALL, mappedBy = "project" )
    private Set<Channel> channels = new HashSet<>();

    @Column( nullable = false )
    @Enumerated( EnumType.STRING )
    private PatchFormat patchFormat;
    
    @ManyToMany
    @JoinTable( name = "project_permitted_clients", joinColumns = @JoinColumn( name = "project_name" ), inverseJoinColumns = @JoinColumn( name = "permitted_clients_id" ) )
    private Set<Client> permittedClients = new HashSet<>();

    Project()
    {
    }

    public Project( String name, PatchFormat format )
    {
        Assert.hasText( name );
        Assert.notNull( format );
        Assert.isTrue( name.matches( NAME_REGEX ), "Name must match regex: " + NAME_REGEX );

        this.name = name.toLowerCase();
        this.patchFormat = format;
    }

    public String getName()
    {
        return name;
    }

    public PatchFormat getPatchFormat()
    {
        return patchFormat;
    }
    
    public Set<Channel> getChannels()
    {
        return channels;
    }

    public Set<Client> getPermittedClients()
    {
        return permittedClients;
    }
    
    public void permitClients(List<Client> clients)
    {
        permittedClients.clear();
        permittedClients.addAll( clients );
    }
}