package com.suncode.autoupdate.server.patch.dto;

import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.PatchProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.*;

@Getter
@Setter
public class PatchDto
{
    private String id;

    private String fromVersion;

    private String toVersion;

    private Date uploaded;
    
    private String checksum;

    private boolean archived;

    private Map<String, String> properties = new HashMap<>();

    public PatchDto( Patch patch )
    {
        this.id = patch.getId().toString();
        this.fromVersion = patch.getFromVersion().getVersion();
        this.toVersion = patch.getToVersion().getVersion();
        this.uploaded = patch.getUploaded();
        this.checksum = patch.getChecksum();
        this.archived = patch.isArchived();
        for ( PatchProperty property : patch.getProperties() )
        {
            this.properties.put( property.getKey(), property.getValue() );
        }
    }

    public static List<PatchDto> from( Collection<Patch> patches )
    {
        List<PatchDto> dtos = new ArrayList<>();
        for ( Patch patch : patches )
        {
            dtos.add( new PatchDto( patch ) );
        }
        return dtos;
    }

    public static PatchDto from(Patch patch) {
        return patch != null ? new PatchDto(patch) : null;
    }
}
