package com.suncode.autoupdate.server.patch;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;

@Entity
public class PatchProperty
{
    @Id
    @GeneratedValue
    private Long id;

    @Column( nullable = false )
    private String key;

    @Column( nullable = false )
    private String value;

    @ManyToOne
    private Patch patch;

    PatchProperty()
    {
    }

    public PatchProperty( String key, String value, Patch patch )
    {
        this.key = key;
        this.value = value;
        this.patch = patch;
    }

    public Long getId()
    {
        return id;
    }

    public String getKey()
    {
        return key;
    }

    public String getValue()
    {
        return value;
    }

    public Patch getPatch()
    {
        return patch;
    }
}
