package com.suncode.autoupdate.server.event;

import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;

public interface EventRepository
    extends PagingAndSortingRepository<Event, Long>, JpaSpecificationExecutor<Event>
{
    @Modifying
    @Query("delete from Event e where e.patch in (select p.id from Patch p where p.channel.project.name = ?1)")
    void deleteByProject(String project);
    
    @Modifying
    @Query("delete from Event e where e.patch.id = ?1")
    void deleteByPatch(String id);
}
