package com.suncode.autoupdate.server.event;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.springframework.util.Assert;

@MappedSuperclass
public abstract class AbstractEvent
{
    @Id
    @GeneratedValue
    private Long id;

    @Enumerated( EnumType.STRING )
    @Column( nullable = false )
    private EventType type;

    @Temporal( TemporalType.TIMESTAMP )
    @Column( nullable = false )
    private Date date;

    AbstractEvent()
    {
    }

    public AbstractEvent( EventType type )
    {
        Assert.notNull( type );
        this.type = type;
        this.date = new Date();
    }

    public Long getId()
    {
        return id;
    }

    public EventType getType()
    {
        return type;
    }

    public Date getDate()
    {
        return date;
    }

}
