package com.suncode.autoupdate.server.client;

import com.suncode.autoupdate.server.client.dto.ClientDto;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * Trial client REST API
 * 
 * @author Cezary Kozar 18 maj 2016
 */
@RestController
@RequestMapping( "/trial" )
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
public class TrialClientController
{
    private final ClientRepository clientRepository;

    @RequestMapping(method = RequestMethod.POST )
    public ClientDto registerTrial()
    {
        Client client = Client.trial();
        clientRepository.save( client );

        return new ClientDto( client );
    }
}
