package com.suncode.autoupdate.server.channel.graph;

import com.suncode.autoupdate.server.patch.Patch;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

import java.util.List;

import static java.util.Collections.emptyList;

@Value
@Builder
public class AvailablePatches {
    Patch newest;
    @Singular("upgrade") List<Patch> newer;
    @Singular("downgrade") List<Patch> older;

    public static AvailablePatches none() {
        return new AvailablePatches(null, emptyList(), emptyList());
    }
}
