package com.suncode.autoupdate.server.channel;

import lombok.SneakyThrows;
import lombok.Value;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

import static org.springframework.hateoas.mvc.ControllerLinkBuilder.linkTo;
import static org.springframework.http.MediaType.APPLICATION_OCTET_STREAM_VALUE;

@Slf4j
@RestController
@RequestMapping("/resources/{resourceId}")
@Secured("ROLE_ADMIN")
public class TempResourcesController {
    private final Map<UUID, TempResource> resources = new ConcurrentHashMap<>();

    public URI serve(String filename, File file) {
        UUID id = UUID.randomUUID();
        resources.put(id, new TempResource(file, filename));
        return linkTo(TempResourcesController.class, id).toUri();
    }

    @GetMapping
    @SneakyThrows
    public void resource(@PathVariable UUID resourceId, HttpServletResponse response) {
        TempResource resource = resources.get(resourceId);
        try {
            response.setHeader("Content-Type", APPLICATION_OCTET_STREAM_VALUE);
            response.setContentLengthLong(resource.getFile().length());
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", resource.getFilename()));

            try (InputStream in = new FileInputStream(resource.getFile());
                 OutputStream out = response.getOutputStream()) {
                IOUtils.copy(in, out);
            }
        } finally {
            resource.getFile().delete();
        }
    }

    @Value
    private static class TempResource {
        File file;
        String filename;
    }
}
