import React, { useState } from "react";
import AsyncSelect from "react-select/async";

function queryProducts(products, query) {
  return products
    .filter(
      product => matches(product.name, query) || matches(product.slug, query)
    )
    .map(product => {
      const isPlugin = product.tags.some(tag => tag.slug.startsWith("plugin"));
      return {
        value: product.id,
        label: `${product.name} (${product.slug})`,
        isPlugin,
        product: product
      };
    });
}

export default props => {
  const [products, setProducts] = useState();
  return (
    <AsyncSelect
      cacheOptions
      defaultOptions
      styles={{
        option: (styles, { data, isDisabled, isFocused, isSelected }) => {
          return {
            ...styles,
            ...(!data.isPlugin && {
              color: "#D0D0D0"
            })
          };
        }
      }}
      loadOptions={query => {
        if (products) {
          return Promise.resolve(queryProducts(products, query));
        }

        return fetch("/store/products")
          .then(response => response.json())
          .then(products => {
            setProducts(products);
            return queryProducts(products, query);
          });
      }}
      {...props}
    />
  );
};

function matches(text, query) {
  return text.toLowerCase().search(query.toLowerCase()) > -1;
}
