import React from 'react';
import ReactJson from 'react-json-view'

export default class PatchProperties extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
    }

    render() {
        if (!this.props.patch?.properties) {
            return null;
        }

        return (
            <table className="table table-bordered margin-bottom-10">
                <tbody>
                {Object.keys(this.props.patch.properties).map(key => {
                    const value = this.props.patch.properties[key];
                    const json = asJson(value);
                    return <tr key={key}>
                        <td style={{width: "1%"}}><p className="text-muted">{key}</p></td>
                        <td>{
                            json ? <ReactJson
                                name={null}
                                quotesOnKeys={false}
                                displayDataTypes={false}
                                enableClipboard={false}
                                shouldCollapse={(field) => !(this.props.collapsed === false ) && field.name == null} // collapse root only
                                src={json}
                            /> : value
                        }</td>
                    </tr>;
                })}
                </tbody>
            </table>
        );
    }
}

function asJson(text) {
    try {
        return JSON.parse(text);
    } catch (e) {
        return null;
    }
}