import React from 'react';
import ReactDOM from 'react-dom';

import PatchesGraph from './PatchesGraph.jsx';
import PatchesDownload from './PatchesDownload.jsx';
import PatchesTable from './PatchesTable.jsx';
import PatchProperties from './PatchProperties.jsx';

export default class Channel extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
        this.showPatchesTable = this.showPatchesTable.bind(this);
        this.showPatchesGraph = this.showPatchesGraph.bind(this);
        this.showPatchesDownload = this.showPatchesDownload.bind(this);
        this.deleteChannel = this.deleteChannel.bind(this);
    }
    componentDidMount() {}

    showPatchesGraph() {
      this.renderChannelView(<PatchesGraph channel={this.props.channel}/>);
    }

    showPatchesTable() {
      this.renderChannelView(<PatchesTable channel={this.props.channel}/>);
    }
    
    showPatchesDownload() {
      this.renderChannelView(<PatchesDownload channel={this.props.channel}/>);
    }

    renderChannelView(cmp){
      var target = document.getElementById('channel-container');
      ReactDOM.unmountComponentAtNode(target);
      ReactDOM.render(cmp, target);
    }

    render() {
        var channel = this.props.channel; 
        return (
            <div className="jarviswidget jarviswidget-color-blueDark">
                <header>
                    <h2>{channel.name}</h2>
                </header>
                <div>
                    <div className="widget-body">
                        <ul className="list-unstyled">
                            <li>
                                <p className="text-muted">
                                    <i className="fa fa-folder"></i>
                                    &nbsp;&nbsp;Ilość:&nbsp;
                                    <span className="txt-color-darken">
                                        {channel.patchesCount}
                                    </span>
                                </p>
                            </li>
                            <li>
                                <p className="text-muted">
                                    <i className="fa fa-cloud-download"></i>
                                    &nbsp;&nbsp;Najnowsza wersja:&nbsp;
                                    <span className="txt-color-darken">
                                        {channel.newestPatch ? channel.newestPatch.toVersion : ''}
                                    </span>
                                </p>
                            </li>
                            <li>
                                <div className="text-muted">
                                    <i className="fa fa-table"></i>
                                    &nbsp;&nbsp;Metadata:&nbsp;
                                    <PatchProperties patch={channel.newestPatch}/>
                                </div>
                            </li>
                        </ul>
                        <div className="row">
                            <div className="col-md-12">
                                <a onClick={this.showPatchesTable} className="btn btn-default txt-color-blueLight">
                                    <i className="fa fa-list"></i>
                                </a>

                                <a onClick={this.showPatchesGraph} className="btn btn-default txt-color-blueLight">
                                    <i className="fa fa-sitemap"></i>
                                </a>

                                <a onClick={this.showPatchesDownload} className="btn btn-default txt-color-blueLight">
                                    <i className="fa fa-download"></i>
                                </a>

                                <a onClick={this.deleteChannel} className="btn btn-danger pull-right">
                                    <i className="fa fa-times"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        );
    }

    deleteChannel() {
        if (confirm('Kanał zostanie usunięty. Jesteś pewny?')) {
            $.ajax({
                url: 'projects/' + this.props.project.name + '/channels/' +  this.props.channel.name,
                method: 'DELETE',
                success: function() {
                    this.props.onDelete(this.props.channel.name);
                }.bind(this)
            });
        }
    }
}
