/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.security;

import com.suncode.autoupdate.server.channel.UpdateChannel;
import com.suncode.autoupdate.server.client.Client;
import com.suncode.autoupdate.server.project.Project;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;

/*
 * Exception performing whole class analysis ignored.
 */
public final class HasAccess {
    public static Predicate<Project> withAccessPredicate(SecurityContextHolderAwareRequestWrapper request) {
        return input -> HasAccess.hasAccessToProject((Project)input, (SecurityContextHolderAwareRequestWrapper)request);
    }

    public static void checkAccessToProject(Project project, SecurityContextHolderAwareRequestWrapper request) {
        if (!HasAccess.hasAccessToProject((Project)project, (SecurityContextHolderAwareRequestWrapper)request)) {
            throw new AccessDeniedException("Not permitted");
        }
    }

    public static boolean hasAccessToProject(UpdateChannel channel, SecurityContextHolderAwareRequestWrapper request) {
        return HasAccess.hasAccessToProject((Project)channel.getChannel().getProject(), (SecurityContextHolderAwareRequestWrapper)request);
    }

    public static boolean hasAccessToProject(Project project, SecurityContextHolderAwareRequestWrapper request) {
        if (request.isUserInRole("ADMIN")) {
            return true;
        }
        Set permitted = project.getPermittedClients();
        if (!permitted.isEmpty()) {
            if (request.isUserInRole("CLIENT")) {
                String client = request.getUserPrincipal().getName();
                for (Client c : permitted) {
                    if (!c.getId().equals(client)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private HasAccess() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

