/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.security;

import com.suncode.autoupdate.server.security.ClientAuthenticationToken;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class ApiTokenAuthenticationFilter
extends OncePerRequestFilter {
    private final AuthenticationManager authenticationManager;

    @Autowired
    public ApiTokenAuthenticationFilter(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String header = request.getHeader("X-Auth-Token");
        if (header == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            ClientAuthenticationToken token = new ClientAuthenticationToken(header);
            ClientAuthenticationToken authResult = (ClientAuthenticationToken)this.authenticationManager.authenticate((Authentication)token);
            MDC.put((String)"client", (Object)authResult.getPrincipal());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authResult);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            MDC.remove((String)"client");
        }
    }
}

