/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.patch.types;

import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.patch.plusworkflow.pluspatch.PlusPatch3Transformer;
import com.suncode.autoupdate.server.patch.PatchHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class PlusWorkflowPatchFormat
implements PatchHandler {
    public boolean transforms(File source) {
        return PlusPatch3Transformer.isPlusPatch3((File)source);
    }

    public Map<String, String> transform(PatchMeta patch, File source, OutputStream out) throws IOException {
        try (Archive archive = this.archive(patch, source);){
            FileUtils.copyFile((File)archive.getFile(), (OutputStream)out);
        }
        return Collections.emptyMap();
    }

    private Archive archive(PatchMeta patch, File rawPatch) throws IOException {
        PlusPatch3Transformer plusPatch = new PlusPatch3Transformer(patch, rawPatch);
        return plusPatch.transform();
    }

    public int compare(String version1, String version2) {
        return Integer.compare(Integer.parseInt(version1), Integer.parseInt(version2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Index readIndex(File patchArchive) {
        try (Archive archive = new Archive(patchArchive);){
            archive.open();
            Index index = archive.getIndex();
            return index;
        }
    }
}

