/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.patch.storage;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.storage.PatchStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class FileSystemPatchStorage
implements PatchStorage {
    private static final Logger log = LoggerFactory.getLogger(FileSystemPatchStorage.class);
    private final File root = new File("data/patches/");

    public FileSystemPatchStorage() throws IOException {
        FileUtils.forceMkdir((File)this.root);
    }

    public void store(Patch patch, File patchFile) throws IOException {
        try (FileInputStream in = new FileInputStream(patchFile);){
            this.store(patch, (InputStream)in);
        }
    }

    public void store(Patch patch, InputStream patchInput) throws IOException {
        this.store(patch, (PatchStorage.StorageOutput)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void store(Patch patch, PatchStorage.StorageOutput output) throws IOException {
        File destination = this.storageFile(patch);
        FileUtils.forceMkdir((File)destination.getParentFile());
        try (HashingOutputStream out = new HashingOutputStream(Hashing.md5(), (OutputStream)new FileOutputStream(destination));){
            output.store((OutputStream)out);
            patch.setChecksum(out.hash().toString());
        }
        log.info("Patch {} stored in {}", (Object)patch.getId(), (Object)destination.getAbsolutePath());
    }

    public Resource read(Patch patch) {
        File archive = this.storageFile(patch);
        if (!archive.exists()) {
            throw new IllegalStateException("Patch not found in [" + archive.getAbsolutePath() + "]!");
        }
        return new FileSystemResource(archive);
    }

    public void purge(Channel.ChannelId channel) throws IOException {
        FileUtils.cleanDirectory((File)this.channelStorageFile(channel));
    }

    private File storageFile(Patch patch) {
        return new File(this.channelStorageFile(patch.getChannel().getId()), patch.getId() + ".patch");
    }

    private File channelStorageFile(Channel.ChannelId channel) {
        return new File(this.root, channel.getProjectName() + "/" + channel.getName());
    }
}

