/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.patch.dto;

import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.PatchProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PatchDto {
    private String id;
    private String fromVersion;
    private String toVersion;
    private Date uploaded;
    private String checksum;
    private boolean archived;
    private Map<String, String> properties = new HashMap();

    public PatchDto(Patch patch) {
        this.id = patch.getId().toString();
        this.fromVersion = patch.getFromVersion().getVersion();
        this.toVersion = patch.getToVersion().getVersion();
        this.uploaded = patch.getUploaded();
        this.checksum = patch.getChecksum();
        this.archived = patch.isArchived();
        for (PatchProperty property : patch.getProperties()) {
            this.properties.put(property.getKey(), property.getValue());
        }
    }

    public static List<PatchDto> from(Collection<Patch> patches) {
        ArrayList<PatchDto> dtos = new ArrayList<PatchDto>();
        for (Patch patch : patches) {
            dtos.add(new PatchDto(patch));
        }
        return dtos;
    }

    public static PatchDto from(Patch patch) {
        return patch != null ? new PatchDto(patch) : null;
    }

    public String getId() {
        return this.id;
    }

    public String getFromVersion() {
        return this.fromVersion;
    }

    public String getToVersion() {
        return this.toVersion;
    }

    public Date getUploaded() {
        return this.uploaded;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFromVersion(String fromVersion) {
        this.fromVersion = fromVersion;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public void setUploaded(Date uploaded) {
        this.uploaded = uploaded;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

