/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.patch;

import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.patch.PatchProperty;
import com.suncode.autoupdate.server.patch.Version;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.springframework.util.Assert;

@Entity
@Table
public class Patch {
    @Id
    private String id;
    @ManyToOne
    private Channel channel;
    @Embedded
    @AttributeOverride(name="version", column=@Column(name="fromVersion", nullable=false))
    private Version fromVersion;
    @Embedded
    @AttributeOverride(name="version", column=@Column(name="toVersion", nullable=false))
    private Version toVersion;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Date uploaded;
    @Column
    private String checksum;
    @Column
    private boolean archived;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="patch")
    private Set<PatchProperty> properties = new HashSet();

    Patch() {
    }

    public Patch(UUID id, Channel channel, Version fromVersion, Version toVersion) {
        Assert.notNull((Object)id);
        Assert.notNull((Object)channel);
        Assert.notNull((Object)toVersion);
        this.id = id.toString();
        this.channel = channel;
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.uploaded = new Date();
    }

    public String getId() {
        return this.id;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Version getFromVersion() {
        return this.fromVersion;
    }

    public Version getToVersion() {
        return this.toVersion;
    }

    public Date getUploaded() {
        return this.uploaded;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public PatchMeta asPatchMeta() {
        return new PatchMeta(this.id, this.fromVersion.getVersion(), this.toVersion.getVersion());
    }

    public Set<PatchProperty> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        for (PatchProperty property : this.properties) {
            if (!property.getKey().equals(name)) continue;
            return property.getValue();
        }
        return null;
    }

    public void addProperty(String key, String value) {
        this.properties.add(new PatchProperty(key, value, this));
    }

    public Patch archive() {
        this.archived = true;
        return this;
    }

    public String toString() {
        return "Patch(id=" + this.getId() + ", fromVersion=" + this.getFromVersion() + ", toVersion=" + this.getToVersion() + ")";
    }
}

