/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.event;

import com.suncode.autoupdate.server.event.Event;
import com.suncode.autoupdate.server.event.EventRepository;
import com.suncode.autoupdate.server.event.EventType;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.PatchRepository;
import com.suncode.autoupdate.server.security.ClientAuthenticationToken;
import java.io.Serializable;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@Transactional
public class Events {
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private PatchRepository patchRepository;

    public void patchDownload(Patch patch, String clientEnv) {
        Event event = new Event(EventType.PATCH_DOWNLOAD, this.currentClient(), clientEnv, patch);
        this.eventRepository.save((Object)event);
    }

    public void patchUpload(Patch patch) {
        Event event = new Event(EventType.PATCH_UPLOAD, this.currentClient(), null, patch);
        this.eventRepository.save((Object)event);
    }

    public void updateSuccess(String patchId, String clientEnv, String data) {
        this.event(EventType.UPDATE_SUCCESS, patchId, clientEnv, data);
    }

    public void updateError(String patchId, String clientEnv, String data) {
        this.event(EventType.UPDATE_ERROR, patchId, clientEnv, data);
    }

    public void rollbackSuccess(String patchId, String clientEnv, String data) {
        this.event(EventType.ROLLBACK_SUCCESS, patchId, clientEnv, data);
    }

    public void rollbackError(String patchId, String clientEnv, String data) {
        this.event(EventType.ROLLBACK_ERROR, patchId, clientEnv, data);
    }

    private void event(EventType eventType, String patchId, String clientEnv, String data) {
        Patch patch = (Patch)this.patchRepository.findOne((Serializable)((Object)patchId));
        Event event = new Event(eventType, this.currentClient(), clientEnv, patch);
        event.setData(data);
        this.eventRepository.save((Object)event);
    }

    private String currentClient() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof ClientAuthenticationToken) {
            return (String)authentication.getPrincipal();
        }
        return null;
    }
}

