/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.event;

import com.suncode.autoupdate.patch.plusworkflow.Props;
import com.suncode.autoupdate.server.event.Event;
import com.suncode.autoupdate.server.event.EventType;
import com.suncode.autoupdate.server.patch.Patch;
import java.util.Date;

public class EventDto {
    private Long id;
    private EventType type;
    private Date date;
    private String client;
    private String clientEnv;
    private String data;
    private String project;
    private String channel;
    private String patchId;
    private String fromVersion;
    private String toVersion;
    private String plusworkflowVersion;
    private String cufVersion;

    public EventDto() {
    }

    public EventDto(Event event) {
        this.id = event.getId();
        this.type = event.getType();
        this.date = event.getDate();
        this.client = event.getClient();
        this.clientEnv = event.getClientEnv();
        this.data = event.getData();
        Patch patch = event.getPatch();
        if (patch != null) {
            this.patchId = patch.getId();
            this.project = patch.getChannel().getId().getProjectName();
            this.channel = patch.getChannel().getId().getName();
            this.fromVersion = patch.getFromVersion().getVersion();
            this.toVersion = patch.getToVersion().getVersion();
            this.plusworkflowVersion = patch.getProperty(Props.PLUSWORKFLOW_VERSION.property());
            this.cufVersion = patch.getProperty("cuf-version");
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getClientEnv() {
        return this.clientEnv;
    }

    public void setClientEnv(String clientEnv) {
        this.clientEnv = clientEnv;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public void setPatchId(String patchId) {
        this.patchId = patchId;
    }

    public String getFromVersion() {
        return this.fromVersion;
    }

    public void setFromVersion(String fromVersion) {
        this.fromVersion = fromVersion;
    }

    public String getToVersion() {
        return this.toVersion;
    }

    public void setToVersion(String toVersion) {
        this.toVersion = toVersion;
    }

    public String getPlusworkflowVersion() {
        return this.plusworkflowVersion;
    }

    public void setPlusworkflowVersion(String plusworkflowVersion) {
        this.plusworkflowVersion = plusworkflowVersion;
    }

    public String getCufVersion() {
        return this.cufVersion;
    }

    public void setCufVersion(String cufVersion) {
        this.cufVersion = cufVersion;
    }
}

