/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.client;

import com.suncode.autoupdate.server.client.Client;
import com.suncode.autoupdate.server.client.Environment;
import com.suncode.autoupdate.server.project.Project;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.BooleanUtils;
import org.hibernate.annotations.CreationTimestamp;
import org.springframework.util.Assert;

@Entity
public class Client {
    @Id
    private String id;
    @Column(unique=true, nullable=false)
    private String name;
    @Column
    private String apiToken;
    @Column
    private Type type = Type.STANDARD;
    @Column
    private Boolean compressPatches;
    @CreationTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Date created;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="client_env", joinColumns={@JoinColumn(name="id")})
    private List<Environment> environments = new ArrayList();
    @ManyToMany
    @JoinTable(name="project_permitted_clients", joinColumns={@JoinColumn(name="permitted_clients_id")}, inverseJoinColumns={@JoinColumn(name="project_name")})
    private Set<Project> permittedProjects = new HashSet();

    Client() {
    }

    public Client(String id, String name) {
        Assert.hasText((String)id);
        Assert.hasText((String)name);
        this.id = id;
        this.name = name;
        this.created = new Date();
    }

    public static Client trial() {
        UUID id = UUID.randomUUID();
        Client client = new Client();
        client.id = id.toString();
        client.name = id.toString();
        client.type = Type.TRIAL;
        client.generateApiToken();
        return client;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return Optional.ofNullable(this.type).orElse(Type.STANDARD);
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public void generateApiToken() {
        this.apiToken = UUID.randomUUID().toString();
    }

    public boolean compressPatches() {
        return this.getCompressPatches();
    }

    public Boolean getCompressPatches() {
        return BooleanUtils.toBoolean((Boolean)this.compressPatches);
    }

    public void setCompressPatches(Boolean compressPatches) {
        this.compressPatches = compressPatches;
    }

    public List<Environment> getEnvironments() {
        return this.environments;
    }

    public Date getCreated() {
        return this.created;
    }
}

