/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.channel.dto;

import com.suncode.autoupdate.server.channel.graph.AvailablePatches;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.dto.PatchDto;
import com.suncode.autoupdate.server.util.Lists;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class UpdatesDto {
    private final PatchDto newest;
    private final List<PatchDto> newer;
    private final List<PatchDto> older;

    public static UpdatesDto of(AvailablePatches patches) {
        return new UpdatesDto(PatchDto.from((Patch)patches.getNewest()), Lists.map((Collection)patches.getNewer(), PatchDto::new), Lists.map((Collection)patches.getOlder(), PatchDto::new));
    }

    public static UpdatesDto none() {
        return new UpdatesDto(null, Collections.emptyList(), Collections.emptyList());
    }

    @ConstructorProperties(value={"newest", "newer", "older"})
    public UpdatesDto(PatchDto newest, List<PatchDto> newer, List<PatchDto> older) {
        this.newest = newest;
        this.newer = newer;
        this.older = older;
    }

    public PatchDto getNewest() {
        return this.newest;
    }

    public List<PatchDto> getNewer() {
        return this.newer;
    }

    public List<PatchDto> getOlder() {
        return this.older;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdatesDto)) {
            return false;
        }
        UpdatesDto other = (UpdatesDto)o;
        PatchDto this$newest = this.getNewest();
        PatchDto other$newest = other.getNewest();
        if (this$newest == null ? other$newest != null : !this$newest.equals(other$newest)) {
            return false;
        }
        List this$newer = this.getNewer();
        List other$newer = other.getNewer();
        if (this$newer == null ? other$newer != null : !((Object)this$newer).equals(other$newer)) {
            return false;
        }
        List this$older = this.getOlder();
        List other$older = other.getOlder();
        return !(this$older == null ? other$older != null : !((Object)this$older).equals(other$older));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PatchDto $newest = this.getNewest();
        result = result * 59 + ($newest == null ? 43 : $newest.hashCode());
        List $newer = this.getNewer();
        result = result * 59 + ($newer == null ? 43 : ((Object)$newer).hashCode());
        List $older = this.getOlder();
        result = result * 59 + ($older == null ? 43 : ((Object)$older).hashCode());
        return result;
    }

    public String toString() {
        return "UpdatesDto(newest=" + this.getNewest() + ", newer=" + this.getNewer() + ", older=" + this.getOlder() + ")";
    }
}

