/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.suncode.autoupdate.server.security.ApiTokenAuthenticationFilter;
import com.suncode.autoupdate.server.security.ApiTokenAuthenticationProvider;
import java.time.Clock;
import javax.servlet.Filter;
import org.jooq.DSLContext;
import org.jooq.conf.RenderNameCase;
import org.jooq.conf.Settings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.http.HttpMethod;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;

@SpringBootApplication
@EnableCaching
@EnableWebSecurity
@EnableScheduling
@EnableGlobalMethodSecurity(securedEnabled=true, proxyTargetClass=true, prePostEnabled=true)
public class UpdateServer
extends WebSecurityConfigurerAdapter {
    @Value(value="${user.username}")
    private String userName;
    @Value(value="${user.password}")
    private String userPassword;

    @Bean
    Clock clock() {
        return Clock.systemUTC();
    }

    @Bean
    Settings jooqSettings() {
        return new Settings().withRenderNameCase(RenderNameCase.LOWER);
    }

    @Bean
    @Primary
    public ObjectMapper objectMapper(DSLContext jooq) {
        return new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).enable(SerializationFeature.INDENT_OUTPUT).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.ALWAYS);
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public ApiTokenAuthenticationFilter apiTokenAuthenticationFilter() throws Exception {
        return new ApiTokenAuthenticationFilter(this.authenticationManagerBean());
    }

    @Bean
    public ApiTokenAuthenticationProvider apiTokenAuthenticationProvider() {
        return new ApiTokenAuthenticationProvider();
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/css/**", "/assets/**", "/fonts/**", "/img/**", "/bundle.js"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable()).authorizeRequests().antMatchers(HttpMethod.POST, new String[]{"/trial"})).permitAll().anyRequest()).authenticated().and()).addFilterBefore((Filter)this.apiTokenAuthenticationFilter(), BasicAuthenticationFilter.class).httpBasic();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.apiTokenAuthenticationProvider()).inMemoryAuthentication().withUser(this.userName).password(this.userPassword).roles(new String[]{"ADMIN", "ACTUATOR"});
    }

    @Bean
    public AcceptHeaderLocaleResolver localeResolver() {
        return new AcceptHeaderLocaleResolver();
    }

    public static void main(String[] args) {
        SpringApplication.run(UpdateServer.class, (String[])args);
    }
}

