import React from 'react';

export default class Jvm extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
    }

    componentWillMount() {
        this.setState({loading: true});
        $.get("metrics").done(metrics=> {
            this.setState({error: false, metrics: metrics});
        }).fail(() => {
            this.setState({error: true});
        }).always(() => {
            this.setState({loading: false});
        });
    }

    componentDidMount() {
        $('.easy-pie-chart').easyPieChart();
    }

    componentDidUpdate() {
        $('.easy-pie-chart').easyPieChart();
    }

    render() {
        if (!this.state.metrics) {
            return null;
        }

        var usedMb = Math.round(this.state.metrics["heap.used"] / 1000);
        var totalMb = Math.round(this.state.metrics["heap"] / 1000);
   		var currentMb = Math.round(this.state.metrics["heap.committed"] / 1000);
        var usedPercent = Math.round(usedMb/totalMb * 100);
        return (
            <div className="panel panel-default">
                <div className="panel-body status">
                  <div className="who padding-5">
	                  <i className="fa fa-hdd-o fa-lg"></i>
	                  <strong> HEAP</strong>
	                </div>
	                <div id="heap">
	                    <ul className="list-unstyled display-inline padding-5">
	                      <li>
	                        <p className="text-muted">
	                          CURRENT:&nbsp;
	                          <span className="txt-color-darken">
	                            {currentMb} MB
	                          </span>
	                        </p>
	                       </li>
	                      <li>
	                        <p className="text-muted">
	                          MAX:&nbsp;
	                          <span className="txt-color-darken">
	                            {totalMb} MB
	                          </span>
	                        </p>
	                      </li>
	                      <li>
	                        <p className="text-muted">
	                          USED:&nbsp;
	                          <span className="txt-color-darken">
	                            {usedMb} MB
	                          </span>
	                        </p>
	                      </li>
	                    </ul>
	                    <div className="easy-pie-chart" data-percent={usedPercent}>
	                        <span className="percent percent-sign">{usedPercent}</span>
	                    </div>
	                </div>
                </div>
            </div>
        );
    }
}
