import React from 'react';
import ReactTable from 'react-table';


export default class ClientsTable extends React.Component {
    constructor() {
        super();
        this.state = {
            data: [],
            pages: null,
            loading: true
        };
        this.fetchData = this.fetchData.bind(this);
        this.clientsLoaded = this.clientsLoaded.bind(this);
    }

    fetchData() {
        this.setState({ loading: true });

        fetch("clients", { credentials: 'same-origin' })
            .then(function(response) {
                return response.json()
            })    
            .then(this.clientsLoaded);
    }

    clientsLoaded(clients) {
        this.setState({
            loading: false,
            data: clients
        });
    }

    render() {
        const { data, loading } = this.state;
        return (
            <div className="well"> 
                <ReactTable ref="clientsTable"
                     columns={[
                        {
                          Header: "Id",
                          accessor: "id"
                        },
                        {
                          Header: "Nazwa",
                          accessor: "name"
                        },
                        {   
                            id: "type",
                            Header: "Type",
                            accessor: "type",
                            width: 150,
                            Filter: function(param) {
                                const {filter, onChange} = param;
                                return <select
                                            onChange={event => onChange(event.target.value)}
                                            style={{ width: "100%" }}
                                            value={filter ? filter.value : "STANDARD"}>
                                    <option value="STANDARD">STANDARD</option>
                                    <option value="TRIAL">TRIAL</option>
                                </select>
                            }
                          },
                        {
                            filterable: false,
                            className: 'text-center',
                            width: 40,
                            Cell: function(row) {
                                return <a href={"#/clients/" + row.original.id} className={"btn btn-default btn-xs txt-color-blue"}>
                                    <i className={"fa fa-edit"}/>
                                </a>
                            }
                        }
                      ]}
                      data={data}
                      loading={loading}
                      onFetchData={this.fetchData}
                      filterable
                      defaultFiltered={[{
                        id: 'type',
                        value: 'STANDARD'
                      }]}
                      defaultSorted={[{
                        id: 'id'
                      }]}
                      minRows = {1}
                      defaultPageSize={100}
                      className="-highlight"
                />
            </div>
        )
    }
}
