import React from 'react';

export default class Select2 extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
    }

    componentWillMount() {
        this.updateOptions(this.props);
    }

    componentWillReceiveProps(nextProps) {
        this.updateOptions(nextProps);
    }

    updateOptions(props) {
        var options = props.values;
        var value = [].concat(props.value);
        var missing = value.filter(value => {
            return !options.find(option => {
                return option.id === value;
            });
        }).map(id => {
            return {id: id, text: id};
        });

        this.setState({options: options.concat(missing)});
    }

    componentDidMount() {
        $(this.refs.selectField).select2({
            ajax: this.props.ajax,
            tags: this.props.tags,
            minimumResultsForSearch: this.props.searchBox
                ? 1
                : -1
        }).on('change.select2', function(e) {
            this.props.onChange($(e.target).val() || []);
        }.bind(this));
    }

    handleChange() {}

    render() {
        return (
            <select ref="selectField" value={this.props.multiple
                  ? this.props.value
                  : this.props.value[0]}
                onChange={this.handleChange}
                multiple={this.props.multiple}
                className="select2 form-control">
                {this.state.options.map(value => {
                    return <option key={value.id} value={value.id}>{value.text}</option>
                })}
            </select>
        )
    }
}
Select2.defaultProps = {
    value: [],
    values: [],
    tags: false,
    multiple: true,
    searchBox: true,
    ajax: undefined,
    onChange: () => {}
};
