import React from 'react';
import ReactDOM from 'react-dom';
import {Router, Route, Link, IndexRedirect, hashHistory} from 'react-router'

import Index from './modules/Index.jsx';
import Dashboard from './modules/dashboard/Dashboard.jsx';
import Clients from './modules/clients/Clients.jsx';
import Client from './modules/clients/Client.jsx';
import Projects from './modules/projects/Projects.jsx';
import Project from './modules/projects/Project.jsx';
import Events from './modules/events/Events.jsx';
import Store from './modules/store/Store.jsx';

class App extends React.Component {
    render() {
        return (
            <Router history={hashHistory}>
                <Route path="/" component={Index}>
                    <IndexRedirect to="dashboard"/>
                    <Route path="dashboard" component={Dashboard}/>
                    <Route path="clients" component={Clients}/>
                    <Route path="clients/:id" component={Client}/>
                    <Route path="projects" component={Projects}/>
                    <Route path="projects/:name" component={Project}/>
                    <Route path="events" component={Events}/>
                    <Route path="store" component={Store}/>
                </Route>
            </Router>
        )
    }
}
ReactDOM.render(
    <App/>, document.getElementById('app'));
