package com.suncode.autoupdate.server.util;

import lombok.experimental.UtilityClass;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;

import static java.util.stream.Collectors.toList;

@UtilityClass
public class Lists {

    public static <V, T> List<T> map(Collection<V> items, Function<V, T> mapFn) {
        return items.stream()
                .map(mapFn)
                .collect(toList());
    }
}
