package com.suncode.autoupdate.server.store.wooapi;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties("store")
@Data
public class ApiConfig {
    String apiURL;
    Credentials credentials;

    @Data
    public static class Credentials {
        String key;
        String secret;

        @Override
        public String toString() {
            return "credentials:redacted";
        }
    }
}

