package com.suncode.autoupdate.server.security;

import com.suncode.autoupdate.server.channel.UpdateChannel;
import com.suncode.autoupdate.server.client.Client;
import com.suncode.autoupdate.server.project.Project;
import lombok.experimental.UtilityClass;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;

import java.util.Set;
import java.util.function.Predicate;

@UtilityClass
public class HasAccess {

    public static Predicate<Project> withAccessPredicate(final SecurityContextHolderAwareRequestWrapper request) {
        return input -> hasAccessToProject(input, request);
    }

    public static void checkAccessToProject(Project project, SecurityContextHolderAwareRequestWrapper request) {
        if (!hasAccessToProject(project, request)) {
            throw new AccessDeniedException("Not permitted");
        }
    }

    public static boolean hasAccessToProject(UpdateChannel channel, SecurityContextHolderAwareRequestWrapper request) {
        return hasAccessToProject(channel.getChannel().getProject(), request);
    }

    public static boolean hasAccessToProject(Project project, SecurityContextHolderAwareRequestWrapper request) {
        if (request.isUserInRole("ADMIN")) {
            return true;
        }

        Set<Client> permitted = project.getPermittedClients();
        if (!permitted.isEmpty()) {
            if (request.isUserInRole("CLIENT")) {
                String client = request.getUserPrincipal().getName();
                for (Client c : permitted) {
                    if (c.getId().equals(client)) {
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }
}
