package com.suncode.autoupdate.server.security;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import com.google.common.collect.Lists;
import com.suncode.autoupdate.server.client.Client;

@SuppressWarnings( "serial" )
public class ClientAuthenticationToken
    extends AbstractAuthenticationToken
{
    private final String principal;
    private final String credencials;
    private final Client client;

    public ClientAuthenticationToken( String token )
    {
        super( null );
        this.principal = token;
        this.credencials = "";
        this.client = null;
    }

    public ClientAuthenticationToken( Client client )
    {
        super( Lists.newArrayList( new SimpleGrantedAuthority( "ROLE_CLIENT" ) ) );
        this.principal = client.getId();
        this.credencials = client.getApiToken();
        this.client = client;
        setAuthenticated( true );
    }

    @Override
    public Object getPrincipal()
    {
        return principal;
    }

    @Override
    public Object getCredentials()
    {
        return credencials;
    }
    
    public Client getClient()
    {
        return client;
    }
}
