package com.suncode.autoupdate.server.security;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

import com.suncode.autoupdate.server.client.Client;
import com.suncode.autoupdate.server.client.ClientRepository;

public class ApiTokenAuthenticationProvider
    implements AuthenticationProvider
{
    @Autowired
    private ClientRepository clientRepository;

    @Override
    public Authentication authenticate( Authentication authentication )
        throws AuthenticationException
    {
        ClientAuthenticationToken token = (ClientAuthenticationToken) authentication;

        Client client = clientRepository.findByApiToken( (String) token.getPrincipal() );
        if ( client == null )
        {
            throw new BadCredentialsException( "Invalid ApiToken specified!" );
        }

        return new ClientAuthenticationToken( client );
    }

    @Override
    public boolean supports( Class<?> authentication )
    {
        return authentication.equals( ClientAuthenticationToken.class );
    }

}
