package com.suncode.autoupdate.server.security;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class ApiTokenAuthenticationFilter
    extends OncePerRequestFilter
{
    private final AuthenticationManager authenticationManager;

    public @Autowired ApiTokenAuthenticationFilter( AuthenticationManager authenticationManager )
    {
        this.authenticationManager = authenticationManager;
    }

    @Override
    protected void doFilterInternal( HttpServletRequest request, HttpServletResponse response, FilterChain chain )
        throws ServletException, IOException
    {
        String header = request.getHeader( "X-Auth-Token" );

        if ( header == null )
        {
            chain.doFilter( request, response );
            return;
        }

        try
        {
            ClientAuthenticationToken token = new ClientAuthenticationToken( header );
            ClientAuthenticationToken authResult = (ClientAuthenticationToken) authenticationManager
                .authenticate( token );

            MDC.put( "client", authResult.getPrincipal() );
            SecurityContextHolder.getContext().setAuthentication( authResult );

            chain.doFilter( request, response );
        }
        finally
        {
            MDC.remove( "client" );
        }
    }

}
