package com.suncode.autoupdate.server.event;

import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;

import com.suncode.autoupdate.server.patch.Patch;

@Entity
public class Event
    extends AbstractEvent
{
    private String client;

    private String clientEnv;

    @ManyToOne
    private Patch patch;

    @Lob
    private String data;

    Event()
    {
    }

    public Event( EventType type, String client, String clientEnv, Patch patch )
    {
        super( type );
        this.client = client;
        this.clientEnv = clientEnv;
        this.patch = patch;
    }

    public String getClient()
    {
        return client;
    }

    public String getClientEnv()
    {
        return clientEnv;
    }

    public Patch getPatch()
    {
        return patch;
    }

    public void setData( String data )
    {
        this.data = data;
    }

    public String getData()
    {
        return data;
    }
}
