package com.suncode.autoupdate.server.client.dto;

import com.suncode.autoupdate.server.client.Client;
import com.suncode.autoupdate.server.client.Environment;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Getter
@Setter
public class ClientDto
{
    private String id;

    private String name;

    private String apiToken;

    private boolean compressPatches;

    private Date created;

    private Client.Type type;

    private List<String> environments = new ArrayList<>();

    public ClientDto()
    {
    }

    public ClientDto( Client client )
    {
        this.id = client.getId();
        this.name = client.getName();
        this.apiToken = client.getApiToken();
        this.compressPatches = client.compressPatches();
        this.created = client.getCreated();
        this.type = client.getType();
        for ( Environment environment : client.getEnvironments() )
        {
            this.environments.add( environment.getName() );
        }
    }
}
