package com.suncode.autoupdate.server.channel.graph;

import lombok.experimental.UtilityClass;
import org.jgrapht.Graph;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.TraversalListenerAdapter;
import org.jgrapht.traverse.DepthFirstIterator;
import org.jgrapht.traverse.GraphIterator;

import java.util.ArrayList;
import java.util.List;

@UtilityClass
public class Traversal {

    public static <V, E> List<E> traverseEdges(Graph<V, E> graph, V start) {
        List<E> edges = new ArrayList<>();

        GraphIterator<V, E> any = new DepthFirstIterator<>(graph, start);
        any.addTraversalListener(new TraversalListenerAdapter<V, E>() {
            @Override
            public void edgeTraversed(EdgeTraversalEvent<V, E> e) {
                edges.add(e.getEdge());
            }
        });
        any.forEachRemaining(node -> {
        });

        return edges;
    }
}
