package com.suncode.autoupdate.server.channel.dto;

import com.suncode.autoupdate.server.channel.graph.AvailablePatches;
import com.suncode.autoupdate.server.patch.dto.PatchDto;
import lombok.Value;

import java.util.List;

import static com.suncode.autoupdate.server.util.Lists.map;
import static java.util.Collections.emptyList;

@Value
public class UpdatesDto {
    PatchDto newest;
    List<PatchDto> newer;
    List<PatchDto> older;

    public static UpdatesDto of(AvailablePatches patches) {
        return new UpdatesDto(
                PatchDto.from(patches.getNewest()),
                map(patches.getNewer(), PatchDto::new),
                map(patches.getOlder(), PatchDto::new));
    }

    public static UpdatesDto none() {
        return new UpdatesDto(null, emptyList(), emptyList());
    }
}
